<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Bank extends Eloquent {

	protected $table = 'bank';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('country_id', 'name_en', 'name_ar');

	public function country()
	{
		return $this->belongsTo('Country', 'country_id');
	}

}