<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('company_name');
			$table->string('name');
			$table->string('phone');
			$table->string('email');
			$table->string('commercial_no');
			$table->bigInteger('sector_id');
			$table->string('commercial_media');
			$table->string('otp')->nullable();
			$table->double('long');
			$table->double('lat');
			$table->tinyInteger('type');
			$table->tinyInteger('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}