<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 255);
			$table->boolean('status');
			$table->string('cover_photo', 255);
			$table->text('short_description');
			$table->text('description');
			$table->integer('organization_id')->unsigned();
			$table->date('start_date');
			$table->date('end_date');
			$table->string('start_time')->nullable();
			$table->double('price');
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}