<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Organization extends Eloquent {

	protected $table = 'organizations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'address', 'email', 'website');
	protected $visible = array('name', 'address', 'email', 'website');

	public function events()
	{
		return $this->hasMany('App\Models\Event');
	}

	public function rates()
	{
		return $this->morphMany('App\Models\Rate');
	}

}