<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Podcast extends Model 
{

    protected $table = 'podcasts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function episodes()
    {
        return $this->hasMany('Episode');
    }

    public function categories()
    {
        return $this->belongsToMany('Category');
    }

    public function quiz()
    {
        return $this->morphOne('Quiz', 'quizzable');
    }

}