<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDayBooksTable extends Migration {

	public function up()
	{
		Schema::create('day_books', function(Blueprint $table) {
			$table->increments('id');
			$table->string('trans_id');
			$table->date('date');
			$table->integer('ledger_id')->unsigned();
			$table->text('description');
			$table->float('debit');
			$table->float('credit');
			$table->float('charges_inward');
			$table->integer('payment_of_charge');
			$table->float('transfer');
			$table->integer('day_bk_status')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('day_books');
	}
}