<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('interaction', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('ticket')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->foreign('ticket_id')->references('id')->on('ticket')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('interaction', function(Blueprint $table) {
			$table->dropForeign('interaction_ticket_id_foreign');
		});
		Schema::table('history', function(Blueprint $table) {
			$table->dropForeign('history_ticket_id_foreign');
		});
	}
}