<?php

namespace Ticket;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ticket extends Model 
{

    protected $table = 'ticket';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getInteractionsAttibute()
    {
        return $this->hasMany('Interaction');
    }

    public function getTicketHistory()
    {
        return $this->hasOne('History');
    }

    public function getCategoryTicket()
    {
        return $this->hasOne('Category');
    }

}