<?php

namespace App\Models;

class UserProfile extends Eloquent {

	protected $table = 'user_profile';
	public $timestamps = false;
	protected $fillable = array('name', 'country_id', 'city_id', 'about');

	public function avatars()
	{
		return $this->hasMany('App\Models\UserAvatar');
	}

	public function city()
	{
		return $this->hasOne('App\Models\City');
	}

	public function country()
	{
		return $this->hasOne('App\Models\Country');
	}

}