<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Allocation extends Model 
{

    protected $table = 'allocations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function wallet()
    {
        return $this->belongsTo('Wallet');
    }

    public function project()
    {
        return $this->belongsTo('Project');
    }

    public function transactions()
    {
        return $this->hasMany('User');
    }

}