<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectionTable extends Migration {

	public function up()
	{
		Schema::create('projection', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->index();
			$table->bigInteger('amount');
			$table->datetime('projected_at');
			$table->bigInteger('project_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('projection');
	}
}