<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNavsTable extends Migration {

	public function up()
	{
		Schema::create('navs', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid')->index();
			$table->bigInteger('project_id')->unsigned()->index();
			$table->bigInteger('amount')->unsigned();
			$table->softDeletes();
			$table->timestamps();
			$table->datetime('date');
		});
	}

	public function down()
	{
		Schema::drop('navs');
	}
}