<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletsTable extends Migration {

	public function up()
	{
		Schema::create('wallets', function(Blueprint $table) {
			$table->increments('id');
			$table->uuid('uuid');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('wallet_provider_id')->unsigned()->nullable()->index();
			$table->string('address')->index();
			$table->datetime('verified_at')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('wallets');
	}
}