<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class State extends Model 
{

    protected $table = 'states';
    public $timestamps = true;

    public function addresses()
    {
        return $this->hasMany('Address', 'state_id');
    }

    public function shops()
    {
        return $this->hasMany('Shop', 'state_id');
    }

    public function city()
    {
        return $this->belongsTo('City');
    }

}