<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNewsletterSubscribersTable extends Migration {

	public function up()
	{
		Schema::create('newsletter_subscribers', function(Blueprint $table) {
			$table->string('newsletter_subscriber_id')->unique()->primary();
			$table->string('email');
			$table->boolean('is_active')->default(1);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('newsletter_subscribers');
	}
}