<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePeliculasTable extends Migration {

	public function up()
	{
		Schema::create('peliculas', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->index();
			$table->integer('production_year')->unsigned();
			$table->date('us_release')->index();
			$table->text('us_release_observation')->nullable();
			$table->text('genre');
			$table->string('director', 255);
			$table->text('cast')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('peliculas');
	}
}