<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BloquePelicula extends Eloquent {

	protected $table = 'bloques_peliculas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('bloques_id', 'pelicula_id');
	protected $visible = array('bloques_id', 'pelicula_id');

	public function bloque()
	{
		return $this->belongsTo('Bloque', 'bloque_id')->withTrashed();
	}

	public function pelicula()
	{
		return $this->belongsTo('Pelicula', 'pelicula_id')->withTrashed();
	}

}