<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Liquidacion extends Eloquent {

	protected $table = 'liquidaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('pelicula_id', 'tipo_liquidacion_id', 'name', 'description');
	protected $visible = array('pelicula_id', 'tipo_liquidacion_id', 'name', 'description');

	public function tipo_liquidacion()
	{
		return $this->belongsTo('TipoLiquidacion', 'tipo_liquidacion_id')->withTrashed();
	}

	public function pelicula()
	{
		return $this->belongsTo('Pelicula', 'pelicula_id')->withTrashed();
	}

	public function estado_liquidacion()
	{
		return $this->hasMany('EstadoLiquidacionLiquidacion', 'liquidacion_id');
	}

}