<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notificacion extends Eloquent {

	protected $table = 'notificaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'tipo_estado_solicitud_id', 'description', 'description_br', 'description_es', 'active');
	protected $visible = array('name', 'tipo_estado_solicitud_id', 'description', 'description_br', 'description_es', 'active');

	public function tipo_estado_solicitud()
	{
		return $this->belongsTo('TipoEstadoSolicitud', 'tipo_estado_solicitud_id')->withTrashed();
	}

	public function solicitudes()
	{
		return $this->hasMany('NotificacionSolicitud', 'notificacion_id');
	}

	public function destinatarios()
	{
		return $this->hasMany('DestinatarioNotificacion', 'notificacion_id');
	}

}