<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class NotificacionSolicitud extends Eloquent {

	protected $table = 'notificaciones_solicitud';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('notificacion_id', 'solicitud_id', 'fecha');
	protected $visible = array('notificacion_id', 'solicitud_id', 'fecha');

	public function solicitud()
	{
		return $this->belongsTo('Solicitud', 'solicitud_id')->withTrashed();
	}

	public function notificacion()
	{
		return $this->belongsTo('Notificacion', 'notificacion_id')->withTrashed();
	}

}