<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Pelicula extends Eloquent {

	protected $table = 'peliculas';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'production_year', 'us_release', 'genre', 'director', 'cast');
	protected $visible = array('name', 'production_year', 'us_release', 'us_release_observation', 'genre', 'director', 'cast');

	public function lineup_pelicula()
	{
		return $this->hasMany('LineUpPelicula', 'pelicula_id');
	}

	public function bloques_peliculas()
	{
		return $this->hasMany('BloquePelicula', 'pelicula_id');
	}

	public function solicitudes()
	{
		return $this->hasMany('Solicitud', 'pelicula_id');
	}

	public function liquidaciones()
	{
		return $this->hasMany('Liquidacion', 'pelicula_id');
	}

}