<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TipoLiquidacion extends Eloquent {

	protected $table = 'tipo_liquidaciones';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name');
	protected $visible = array('name');

	public function liquidaciones()
	{
		return $this->hasMany('Liquidacion', 'liquidacion_id');
	}

}