<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class TipoSolicitud extends Eloquent {

	protected $table = 'tipo_solicitudes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'code', 'modulos_id');
	protected $visible = array('name', 'code', 'modulos_id');

	public function modulo()
	{
		return $this->belongsTo('Modulo', 'modulo_id')->withTrashed();
	}

}