<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('information');

	public function phones()
	{
		return $this->hasMany('Phone');
	}

	public function adresses()
	{
		return $this->hasMany('Adress');
	}

	public function role()
	{
		return $this->hasOne('Role');
	}

	public function sonuclar()
	{
		return $this->hasMany('SinavSonucGenel');
	}

}