<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsRecTable extends Migration {

	public function up()
	{
		Schema::create('paymentsRec', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('tokenNumber')->unique();
			$table->integer('userID')->unsigned();
			$table->integer('recordNumber');
			$table->string('packageName');
			$table->date('transactionDate');
			$table->string('status');
			$table->integer('amount');
			$table->string('vendor');
			$table->text('description');
			$table->integer('tax');
			$table->integer('vat');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('paymentsRec');
	}
}