<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Courses extends Model 
{

    protected $table = 'courses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('start_at', 'expire_at', 'institute', 'name', 'hours_number', 'description', 'lawyer_id');

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

}