<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Discounts extends Model 
{

    protected $table = 'discounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('code', 'name', 'type', 'amount', 'lawyer_id', 'uses', 'max_uses', 'start_ar', 'expire_at', 'user_id', 'email');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function lawyer()
    {
        return $this->belongsTo('Lawyers', 'lawyer_id');
    }

}