<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code');
			$table->string('name');
			$table->enum('type', array('fixed', 'percent'));
			$table->integer('amount');
			$table->integer('lawyer_id');
			$table->integer('uses');
			$table->integer('max_uses');
			$table->date('start_ar');
			$table->date('expire_at');
			$table->integer('user_id');
			$table->string('email');
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}