<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Banks extends Eloquent {

	protected $table = 'banks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_id');

	public function country()
	{
		return $this->belongsTo('Countries', 'country_id');
	}

}