<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cities extends Eloquent {

	protected $table = 'cities';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'country_id');

	public function country()
	{
		return $this->belongsTo('Countries', 'country_id');
	}

}