<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Courses extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('start_at', 'expire_at', 'institute', 'name', 'hours_number', 'description', 'lawyer_id');

	public function lawyer()
	{
		return $this->belongsTo('Lawyers', 'lawyer_id');
	}

}