<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class History extends Eloquent {

	protected $table = 'history';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'status');

	public function order()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

}