<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invitations extends Eloquent {

	protected $table = 'invitations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'lawyer_id', 'price', 'days_offer', 'period', 'status', 'cancel', 'review');

	public function order()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

	public function lawyer()
	{
		return $this->belongsTo('Lawyers', 'lawyer_id');
	}

}