<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Lawyers extends Eloquent {

	protected $table = 'lawyers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'email', 'phone', 'country_id', 'city_id', 'advice_price', 'password', 'birth_date', 'gender', 'brief', 'level_id', 'status', 'available', 'waiting_from', 'waiting_to', 'bank_id', 'account_name', 'balance', 'account_number', 'iban', 'rating');

	public function country()
	{
		return $this->belongsTo('Countries', 'country_id');
	}

	public function city()
	{
		return $this->belongsTo('Cities', 'city_id');
	}

	public function bank()
	{
		return $this->belongsTo('Banks', 'bank_id');
	}

	public function specialties()
	{
		return $this->hasMany('LawyersSpecialties', 'lawyer_id');
	}

	public function languages()
	{
		return $this->hasMany('LawyersLanguages', 'lawyer_id');
	}

	public function level()
	{
		return $this->belongsTo('Levels', 'level_id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function memberships()
	{
		return $this->hasMany('Memberships', 'lawyer_id');
	}

	public function licenses()
	{
		return $this->hasMany('Licenses', 'lawyer_id');
	}

	public function qualifications()
	{
		return $this->hasMany('Qualifications', 'lawyer_id');
	}

	public function experiences()
	{
		return $this->hasMany('Experiences', 'lawyer_id');
	}

}