<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Licenses extends Eloquent {

	protected $table = 'licenses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('start_at', 'expire_at', 'license_number', 'type', 'country_id', 'lawyer_id');

	public function lawyer()
	{
		return $this->belongsTo('Lawyers', 'lawyer_id');
	}

	public function country()
	{
		return $this->belongsTo('Countries', 'country_id');
	}

}