<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Memberships extends Eloquent {

	protected $table = 'memberships';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('organization', 'start_at', 'still', 'expire_at', 'lawyer_id', 'name', 'country_id');

	public function lawyer()
	{
		return $this->belongsTo('Lawyers', 'lawyer_id');
	}

	public function country()
	{
		return $this->belongsTo('Countries', 'country_id');
	}

}