<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Messages extends Eloquent {

	protected $table = 'messages';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('from_user', 'to_user', 'type', 'message', 'order_id', 'is_reply');

	public function from_user()
	{
		return $this->belongsTo('User', 'from_user');
	}

	public function to_user()
	{
		return $this->belongsTo('User', 'to_user');
	}

	public function order()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

}