<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notifications extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'type', 'message');

	public function user()
	{
		return $this->belongsTo('User', 'user_id');
	}

}