<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Offers extends Eloquent {

	protected $table = 'offers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'lawyer_id', 'invitation_id', 'price', 'period', 'status', 'details', 'cancel_reason', 'read');

	public function order()
	{
		return $this->belongsTo('Orders', 'order_id');
	}

	public function lawyer()
	{
		return $this->hasOne('Lawyers', 'lawyer_id');
	}

	public function invitations()
	{
		return $this->belongsTo('Invitations', 'invitation_id');
	}

}