<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Payouts extends Eloquent {

	protected $table = 'payouts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('lawyer_id', 'amount', 'status', 'process_date');

	public function lawyer()
	{
		return $this->belongsTo('Lawyers', 'lawyer_id');
	}

}