<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class RatingStars extends Eloquent {

	protected $table = 'rating_stars';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('rating_id', 'rate', 'question_id');

	public function rating()
	{
		return $this->belongsTo('Rating', 'rating_id');
	}

	public function question()
	{
		return $this->belongsTo('RatingQuestions', 'question_id');
	}

}