<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('walletTransactions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('wallet_id')->unsigned();
			$table->tinyInteger('status');
			$table->integer('merchant_id')->unsigned();
			$table->integer('transaction_initialized_by')->unsigned();
			$table->integer('transaction_validated_by')->unsigned();
			$table->string('financial_institution', 100);
		});
	}

	public function down()
	{
		Schema::drop('walletTransactions');
	}
}