<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_user', 'id_post', 'content', 'rate');
	protected $visible = array('id_user', 'id_post', 'content', 'rate');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'id_user');
	}

	public function post()
	{
		return $this->belongsTo('App\Models\Post', 'id_post');
	}

}