<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Shop extends Eloquent {

	protected $table = 'shops';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('id_user', 'name', 'id_category', 'status', 'actived_at', 'disabled_at', 'banner', 'description');
	protected $visible = array('id_user', 'name', 'id_category', 'status', 'actived_at', 'disabled_at', 'banner', 'description');

	public function user()
	{
		return $this->belongsTo('App\Models\User', 'id_user');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category', 'id_category');
	}

	public function certifications()
	{
		return $this->morphMany('App\Models\Certification', 'certifiable_id');
	}

}