<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Social extends Eloquent {

	protected $table = 'socials';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'url', 'description');
	protected $visible = array('id_user', 'name', 'url', 'description', 'timestamps');

	public function user()
	{
		return $this->belongsTo('User');
	}

}