<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAssessmentsTable extends Migration {

	public function up()
	{
		Schema::create('assessments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('department_id')->unsigned()->index();
			$table->integer('tool_id')->unsigned()->index();
			$table->integer('previous_assessment_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('import_id', 64)->nullable();
			$table->string('source', 32)->nullable();
			$table->string('import_version', 15)->nullable();
			$table->timestamp('date_conducted')->index();
			$table->tinyInteger('tool_version_major')->nullable()->index();
			$table->enum('assessment_type', array('BASE', 'SEQ'))->index();
			$table->enum('assessment_class', array('INITIAL', 'FOLLOW_UP'))->index();
			$table->integer('user_id')->unsigned()->index();
			$table->tinyInteger('tool_version_minor')->index();
			$table->integer('tool_version_patch')->nullable()->index();
			$table->string('tool_version_label', 16)->nullable()->index();
			$table->string('assessment_dats')->nullable()->default('json');
		});
	}

	public function down()
	{
		Schema::drop('assessments');
	}
}