<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOwnersTable extends Migration {

	public function up()
	{
		Schema::create('owners', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 256)->nullable()->index();
			$table->string('acronym', 8)->nullable()->index();
			$table->enum('owner_type', array('HEALTH_GROUP', 'GOVERNMENT', 'INDEPENDENT'));
			$table->enum('role_type', array('OWNER', 'MANAGER', 'BOTH'));
			$table->string('import_id', 64)->nullable();
			$table->string('source', 32)->nullable();
			$table->string('import_version', 15)->nullable();
			$table->string('permissions')->nullable()->default('json');
			$table->string('owner_role', 32)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('owners');
	}
}