<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('facilities', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->foreign('manager_owner_id')->references('id')->on('owners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('owner_defined_categories', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('facility_facility_classes', function(Blueprint $table) {
			$table->foreign('facility_class_id')->references('id')->on('facility_classes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('facility_facility_classes', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_password_histories', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_facilities', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_facilities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('department_type_id')->references('id')->on('department_types')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->foreign('tool_id')->references('id')->on('tools')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->foreign('previous_assessment_id')->references('id')->on('assessments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('owner_id')->references('id')->on('owners')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('review_assessments', function(Blueprint $table) {
			$table->foreign('assessment_id')->references('id')->on('assessments')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('review_assessments', function(Blueprint $table) {
			$table->foreign('review_id')->references('id')->on('reviews')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('facility_owner_defined_categories', function(Blueprint $table) {
			$table->foreign('owner_defined_category_id')->references('id')->on('owner_defined_categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('facility_owner_defined_categories', function(Blueprint $table) {
			$table->foreign('facility_id')->references('id')->on('facilities')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('facilities', function(Blueprint $table) {
			$table->dropForeign('facilities_owner_id_foreign');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->dropForeign('facilities_manager_owner_id_foreign');
		});
		Schema::table('owner_defined_categories', function(Blueprint $table) {
			$table->dropForeign('owner_defined_categories_owner_id_foreign');
		});
		Schema::table('facility_facility_classes', function(Blueprint $table) {
			$table->dropForeign('facility_facility_classes_facility_class_id_foreign');
		});
		Schema::table('facility_facility_classes', function(Blueprint $table) {
			$table->dropForeign('facility_facility_classes_facility_id_foreign');
		});
		Schema::table('user_password_histories', function(Blueprint $table) {
			$table->dropForeign('user_password_histories_user_id_foreign');
		});
		Schema::table('user_facilities', function(Blueprint $table) {
			$table->dropForeign('user_facilities_facility_id_foreign');
		});
		Schema::table('user_facilities', function(Blueprint $table) {
			$table->dropForeign('user_facilities_user_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_department_type_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_facility_id_foreign');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->dropForeign('assessments_department_id_foreign');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->dropForeign('assessments_tool_id_foreign');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->dropForeign('assessments_previous_assessment_id_foreign');
		});
		Schema::table('assessments', function(Blueprint $table) {
			$table->dropForeign('assessments_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_facility_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_owner_id_foreign');
		});
		Schema::table('review_assessments', function(Blueprint $table) {
			$table->dropForeign('review_assessments_assessment_id_foreign');
		});
		Schema::table('review_assessments', function(Blueprint $table) {
			$table->dropForeign('review_assessments_review_id_foreign');
		});
		Schema::table('facility_owner_defined_categories', function(Blueprint $table) {
			$table->dropForeign('facility_owner_defined_categories_owner_defined_category_id_foreign');
		});
		Schema::table('facility_owner_defined_categories', function(Blueprint $table) {
			$table->dropForeign('facility_owner_defined_categories_facility_id_foreign');
		});
	}
}