<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OwnerDefinedCategory extends Eloquent {

	protected $table = 'owner_defined_categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'description');

	public function owner()
	{
		return $this->belongsTo('App\Models\Owner');
	}

}