<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrendTaxiAppPricesTable extends Migration {

	public function up()
	{
		Schema::create('trend_taxi_app_prices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 64)->nullable();
			$table->string('lang', 2)->nullable()->default('uz');
			$table->string('car_type', 24)->nullable()->default('Start');
			$table->string('image', 255)->nullable();
			$table->string('alt', 255)->nullable();
			$table->decimal('start', 15,2)->nullable()->default('0.00');
			$table->decimal('km', 15,2)->nullable()->default('0.00');
			$table->decimal('paid', 15,2)->nullable()->default('0.00');
			$table->decimal('fee', 2,2)->default('10.00');
		});
	}

	public function down()
	{
		Schema::drop('trend_taxi_app_prices');
	}
}